﻿<?xml version='1.0' encoding='utf-8' standalone='yes'?>
<assembly
    xmlns="urn:schemas-microsoft-com:asm.v3"
    xmlns:xsd="http://www.w3.org/2001/XMLSchema"
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
    manifestVersion="1.0"
    >
  <!--
       The same manifest is used for both server migration and client migration.
       We must not change the assembly identy name of the manifest, or we risk breaking our link
       with the server migration tools.
       
       In Win8, BranchCache has two manifests with <migration> sections:
           PeerDist-Server-Migration:  Covers all migration scenarios, with SettingsVersion=2
           PeerDist-Upgrade: New to Win8.  Covers all upgrade scenarios, with SettingsVersion=2 for consistency
       
       In Win7, BranchCache originally had two manifests:
           PeerDist-Server-Migration: Covered both upgrade and migration scenarios for Server SKUs with SettingsVersion=1
           PeerDist-Client-Migration: Covered both upgrade and migration scenarios for Client SKUs with SettingsVersion=1

       In Win8, we defined replacement manifests for the Win7 manifests.  In the replacement manifests:
          PeerDist-Server-Migration: Covers only migration for server SKUs with SettingsVersion=1
          PeerDist-Client-Migration: Covers only migration for client SKUs with SettingsVersion=1
          PeerDist-Upgrade: Covers upgrade scenarios with SettingsVersion=1
       
       SettingsVersion=0 was used in pre-release versions of Win7.
  -->
  <assemblyIdentity
      name="Microsoft-Windows-PeerDist-Upgrade"
      processorArchitecture="*"
      version="0.0.0.0"
      />
  <!-- Defines the upgrade rules for Win7, with SettingsVersion=1 -->
  <migration
      alwaysProcess="yes"
      replacementSettingsVersionRange="1"
      replacementVersionRange="6.1.*"
      scope="Upgrade"
      settingsVersion="1"
      >
    <migXml xmlns="">
      <!-- Defines custom environment variables for our cache file locations, based on current registry settings. -->
      <rules context="System">
        <include>
          <objectSet>
            <!-- Captures the BranchCache registry tree -->
            <pattern type="Registry">HKLM\Software\Microsoft\Windows NT\CurrentVersion\PeerDist\* [*]</pattern>
            <!-- Captures the publication and republication cache directories -->
            <pattern type="File">%WINDIR%\ServiceProfiles\NetworkService\AppData\Local\PeerDistPub\* [*]</pattern>
            <pattern type="File">%WINDIR%\ServiceProfiles\NetworkService\AppData\Local\PeerDistRepub\* [*]</pattern>
          </objectSet>
        </include>
        <!-- Make certain the old republication cache files get written, even the service had a chance to start up earlier in the upgrade. -->
        <merge script="MigXmlHelper.SourcePriority()">
          <objectSet>
            <pattern type="File">%WINDIR%\ServiceProfiles\NetworkService\AppData\Local\PeerDistPub\* [*]</pattern>
            <pattern type="File">%WINDIR%\ServiceProfiles\NetworkService\AppData\Local\PeerDistRepub\* [*]</pattern>
          </objectSet>
        </merge>
      </rules>
    </migXml>
  </migration>
</assembly>
